<?php
/**
 * Created by PhpStorm.
 * User: server
 * Date: 1/07/23
 * Time: 05:21 PM
 */

require_once "conection.php";
require_once "catalogos.php";
require_once "bitacora.model.php";
require_once $_SERVER['DOCUMENT_ROOT']."/pruebas.api.bbva/libs/fechas.php";

class solicitudAsignacionSetModel{

    static public $pdo;
    static private $cveavaluo;

    static public function saveSolicitud($solicitud){

        //Setear variables
        $cond_suceptible_embargo = "";
        $cond_suceptible_embargoC = "";
        $cond_suceptible_embargoD = "";

        $cond_requiere_valor_liquidacion = "";
        $cond_requiere_valor_liquidacionC = "";
        $cond_requiere_valor_liquidacionD = "";

        $cond_tasacion_anterior_vigencia = "";
        $cond_tasacion_anterior_vigenciaC = "";
        $cond_tasacion_anterior_vigenciaD = "";

        /*
        if($solicitud->susceptible_embargo != "") {
            $val = ($solicitud->susceptible_embargo == "Si") ? 1:0;
            $cond_suceptible_embargoC = "susceptible_embargo,";
            $cond_suceptible_embargoD = "'".$val."',";
        }*/

        if($solicitud->susceptible_embargo != "") {
            $val = $solicitud->susceptible_embargo;
            $cond_suceptible_embargoC = "susceptible_embargo,";
            $cond_suceptible_embargoD = "'".$val."',";
        }

        /*
        if($solicitud->requiere_valor_liquidacion != ""){
            $val = ($solicitud->requiere_valor_liquidacion == "Si") ? 1:0;
            $cond_requiere_valor_liquidacionC = "requiere_valor_liquidacion,";
            $cond_requiere_valor_liquidacionD = "'".$val."',";
        }*/

        if($solicitud->requiere_valor_liquidacion != ""){
            $val = $solicitud->requiere_valor_liquidacion;
            $cond_requiere_valor_liquidacionC = "requiere_valor_liquidacion,";
            $cond_requiere_valor_liquidacionD = "'".$val."',";
        }

        if($solicitud->tasacion_anterior_vigencia != ""){
            $cond_tasacion_anterior_vigenciaC = "tasacion_anterior_vigencia,";
            $cond_tasacion_anterior_vigenciaD = "'".$solicitud->tasacion_anterior_vigencia."',";
        }

        $cond_urgenteC = "urgente,";
        $cond_urgenteD = "'".$solicitud->urgente."',";
        /*if($solicitud->urgente == "")
            $cond_urgenteD = '0';*/

        $sql = "
                INSERT INTO bbva_solicitudes
                  (
                    _cveestatus,
                    entidades_id,
                    finalidades_id,
                    productos_id,
                    precio_valor_estimado,
                    $cond_suceptible_embargoC
                    $cond_requiere_valor_liquidacionC
                    crs_id,
                    crs_oficina,
                    categorias_inmueble_id,
                    tipos_inmueble_id,
                    nombre_proyecto,
                    numero_vivienda,

                    numero_credito,
                    numero_segundo_credito,
                    solicitante_tipos_personas_id,
                    solicitante_nombre,
                    solicitante_paterno,
                    solicitante_materno,
                    solicitante_tributaria_clave,
                    solicitante_telefono,
                    solicitante_movil,
                    solicitante_email,
                    solicitante_numero_seguridad_social,
                    solicitante_curp,
                    acreditado_nombre,
                    acreditado_tributaria_clave,
                    tasacion_anterior_folio,
                    $cond_tasacion_anterior_vigenciaC
                    propietario_nombre,
                    propietario_telefono,
                    propietario_rfc,
                    propietario_curp,
                    promotor_comercial,
                    promotor_clave_cuenta,
                    latitud,
                    longitud,
                    altitud,
                    nuevo_usado_id,
                    clave_unica_vivienda,
                    cuenta_predial,
                    notario_numero,
                    notario_nombre,
                    notario_plaza,
                    notario_escritura,
                    notario_libro,
                    notario_volumen,
                    comentarios,
                    $cond_urgenteC
                    urgente_motivos_id,
                    urgente_detalle,
                    requiere_medicion,
                    requiere_certificado_catastro,
                    unidades_cantidad,
                    contacto_entrega_fisica
                  )
                 VALUES
                  (
                    '0',
                    '".$solicitud->entidades_id."',
                    '".$solicitud->finalidades_id."',
                    '".$solicitud->productos_id."',
                    '".$solicitud->precio_valor_estimado."',
                    $cond_suceptible_embargoD
                    $cond_requiere_valor_liquidacionD
                    '".$solicitud->crs_id."',
                    '".$solicitud->crs_oficina."',
                    '".$solicitud->categorias_inmueble_id."',
                    '".$solicitud->tipos_inmueble_id."',
                    '".$solicitud->nombre_proyecto."',
                    '".$solicitud->numero_vivienda."',

                    '".$solicitud->numero_credito."',
                    '".$solicitud->numero_segundo_credito."',
                    '".$solicitud->solicitante_tipos_personas_id."',
                    '".$solicitud->solicitante_nombre."',
                    '".$solicitud->solicitante_paterno."',
                    '".$solicitud->solicitante_materno."',
                    '".$solicitud->solicitante_tributaria_clave."',
                    '".$solicitud->solicitante_telefono."',
                    '".$solicitud->solicitante_movil."',
                    '".$solicitud->solicitante_email."',
                    '".$solicitud->solicitante_numero_seguridad_social."',
                    '".$solicitud->solicitante_curp."',
                    '".$solicitud->acreditado_nombre."',
                    '".$solicitud->acreditado_tributaria_clave."',
                    '".$solicitud->tasacion_anterior_folio."',
                    $cond_tasacion_anterior_vigenciaD
                    '".$solicitud->propietario_nombre."',
                    '".$solicitud->propietario_telefono."',
                    '".$solicitud->propietario_rfc."',
                    '".$solicitud->propietario_curp."',
                    '".$solicitud->promotor_comercial."',
                    '".$solicitud->promotor_clave_cuenta."',
                    '".$solicitud->latitud."',
                    '".$solicitud->longitud."',
                    '".$solicitud->altitud."',
                    '".$solicitud->nuevo_usado_id."',
                    '".$solicitud->clave_unica_vivienda."',
                    '".$solicitud->cuenta_predial."',
                    '".$solicitud->notario_numero."',
                    '".$solicitud->notario_nombre."',
                    '".$solicitud->notario_plaza."',
                    '".@$solicitud->notario_escritura."',
                    '".$solicitud->notario_libro."',
                    '".$solicitud->notario_volumen."',
                    '".$solicitud->comentarios."',
                    $cond_urgenteD
                    '".$solicitud->urgente_motivos_id."',
                    '".$solicitud->urgente_detalle."',
                    '".$solicitud->requiere_medicion."',
                    '".$solicitud->requiere_certificado_catastro."',
                    '".$solicitud->unidades_cantidad."',
                    '".$solicitud->contacto_entrega_fisica."'
                  )
            ";

        try{
            //echo $sql;

            self::$pdo = Conection::connect();

            //Begin
            self::$pdo->beginTransaction();

            //Save Solicitud
            $stmt = self::$pdo->prepare($sql);
            $stmt->execute();

            //Del Directions Sol (esta nunca se va a ejecutar)
            if(!empty($cvesolicitud))
                self::delDirSol($cvesolicitud);

            //Get id solicitud
            //$cvesolicitud = self::existeFolioUT($solicitud->folio);
            $cvesolicitud = self::getcvesolicitud();

            #Save Directions
            //1.- Inmueble
            if($solicitud->direcciones->inmueble->codigo_postal != "")
                self::saveDirSol($solicitud->direcciones->inmueble,1,$cvesolicitud);

            //2.- Solicitante
            if($solicitud->direcciones->solicitante->codigo_postal != "")
                self::saveDirSol($solicitud->direcciones->solicitante,2,$cvesolicitud);

            //3.- Propietario
            if($solicitud->direcciones->propietario->codigo_postal != "")
                self::saveDirSol($solicitud->direcciones->propietario,3,$cvesolicitud);

            //4.-  Entrega
            if($solicitud->direcciones->entrega->codigo_postal != "")
                self::saveDirSol($solicitud->direcciones->entrega,4,$cvesolicitud);

            //5.- Cliente
            if($solicitud->direcciones->cliente->codigo_postal != "" || $solicitud->contacto_entrega_fisica != '')
                self::saveDirSol($solicitud->direcciones->cliente,1,$cvesolicitud);

            #Save Contactos
            //Del contactos
            self::delContactos($cvesolicitud);

            //Contacto [0]
            //print_r($solicitud->contactos[0]);
            foreach ($solicitud->contactos as $i => $colContacto){
                foreach ($solicitud->contactos[$i]->roles as $tipo_contacto)
                    self::addContacto($solicitud->contactos[$i],$tipo_contacto,$cvesolicitud);
            }
            
            /*===========================================================
             *  Actualización:
             *  
             *  Soporte para guardar los datos de guías del avalúo con tipo de 
             *  banca DANF.
             *
             *  Modified: 07/Sep/2024 12:16
             *=========================================================*/
            if(count($solicitud->folios_guias)>0){
                foreach($solicitud->folios_guias as $i => $guia){
                    if($solicitud->folios_guias[$i]->folio != "" && $solicitud->folios_guias[$i]->solicitud != ""){
                     
                        $query = "
                            INSERT INTO bbva_solicitud_folios_guias
                                (
                                    _cvesolicitud,
                                    folio,
                                    solicitud,
                                    nombre_deudor,
                                    direccion,
                                    colonia,
                                    conjunto,
                                    nivel1,
                                    nivel2,
                                    codigo_postal,
                                    tipo_bien_id,
                                    productos_id,
                                    finalidades_id,
                                    m2_terreno,
                                    m2_construccion,
                                    valor_referencia_origen,
                                    folio_referencia_origen,
                                    comentario_valor,
                                    divisional_id,
                                    situacion_id,
                                    calificacion_id,
                                    vigilancia_id,
                                    sub_inventario_id,
                                    comentario_adicional,
                                    observaciones
                                )
                            VALUES
                                (
                                    '".$cvesolicitud."',
                                    '".$solicitud->folios_guias[$i]->folio."',
                                    '".$solicitud->folios_guias[$i]->solicitud."',
                                    '".$solicitud->folios_guias[$i]->nombre_deudor."',
                                    '".$solicitud->folios_guias[$i]->direccion."',
                                    '".$solicitud->folios_guias[$i]->colonia."',
                                    '".$solicitud->folios_guias[$i]->conjunto."',
                                    '".$solicitud->folios_guias[$i]->nivel1."',
                                    '".$solicitud->folios_guias[$i]->nivel2."',
                                    '".$solicitud->folios_guias[$i]->codigo_postal."',
                                    '".$solicitud->folios_guias[$i]->tipo_bien_id."',
                                    '".$solicitud->folios_guias[$i]->productos_id."',
                                    '".$solicitud->folios_guias[$i]->finalidades_id."',
                                    '".$solicitud->folios_guias[$i]->m2_terreno."',
                                    '".$solicitud->folios_guias[$i]->m2_construccion."',
                                    '".$solicitud->folios_guias[$i]->valor_referencia_origen."',
                                    '".$solicitud->folios_guias[$i]->folio_referencia_origen."',
                                    '".$solicitud->folios_guias[$i]->comentario_valor."',
                                    '".$solicitud->folios_guias[$i]->divisional_id."',
                                    '".$solicitud->folios_guias[$i]->situacion_id."',
                                    '".$solicitud->folios_guias[$i]->calificacion_id."',
                                    '".$solicitud->folios_guias[$i]->vigilancia_id."',
                                    '".$solicitud->folios_guias[$i]->sub_inventario_id."',
                                    '".$solicitud->folios_guias[$i]->comentario_adicional."',
                                    '".$solicitud->folios_guias[$i]->observaciones."'
                                )
                        ";
                        //echo $query;
                        
                        //Save Solicitud
                        $stmt = self::$pdo->prepare($query);
                        $stmt->execute();
                        
                        $cvebbva_solicitud_folio_guia = self::$pdo->lastInsertId();
                        //echo "id Folio Guía:".$cvebbva_solicitud_folio_guia."<br />";
                        
                        /*==============================
                         * Guardamos las obsolescencias
                         *==============================*/
                         
                        //Catalogo tipo de obsolescencias 
                        $obsTipo = Catalogos::getTipoObsolescencias();
                        
                        foreach($obsTipo as $j => $obs){
                         
                            //echo "La obsolescencia es:".$j."<br />";
                            //echo "EL ID de obsolescencia es:".$obs."<br />";
                            
                            /*var_dump($solicitud->folios_guias[$i]->obsolescencias->{$j});*/
                               
                            foreach($solicitud->folios_guias[$i]->obsolescencias->{$j} as $k => $subtipo){
                                self::saveObsolescencias($obs,$subtipo,$cvebbva_solicitud_folio_guia);    
                            }
                            
                        }
                        //==============================// 
                        
                    }
                }    
            }
            

            //=========================================================//

            //Grabamos los cambios en el sisval
            $cveavaluo = self::saveSolicitudSisval('',$solicitud,$cvesolicitud);

            
            if($cveavaluo != ""){

                #New

                //Actualizamos el foliosisval en la tabla de solicitudes
                $cveavaluo2 = str_pad($cveavaluo,10,0,STR_PAD_LEFT);
                $sqlActFolSisInSolicitudes = "
                    UPDATE  bbva_solicitudes
                    SET     _cveavaluo    = '$cveavaluo',
                            _cveavaluo2   = '$cveavaluo2'
                    WHERE   cvesolicitud  = '$cvesolicitud' 
                ";
                $stmtActFolSisInSol = self::$pdo->prepare($sqlActFolSisInSolicitudes);
                $stmtActFolSisInSol->execute();

                //grabamos en bitacora
                $cveevento_bitacora = bitacoraModel::agregar("bbva_0",self::$cveavaluo,"Folio UV:".$cveavaluo2);

                self::$pdo->commit();

                return array(true,'',$cveavaluo);

            }else{
                self::$pdo->rollBack();
                return array(false,1,$e->getMessage());    
            }            

        }catch (PDOException $e){
            self::$pdo->rollBack();
            return array(false,1,$e->getMessage());
        }
    }
    
    #Save obsolescencias
    static private function saveObsolescencias($tipo,$obs,$cvebbva_solicitud_folio_guia){
        $query = "
            INSERT INTO bbva_solicitud_folios_guias_obsolescencias
                (
                    _cvebbva_solicitud_folio_guia,
                    obsolescencia,
                    subtipo
                )
                VALUES
                (
                    '".$cvebbva_solicitud_folio_guia."',
                    '".$tipo."',
                    '".$obs."'
                )
        ";
        //echo $query."<br />";
        
        if(self::$pdo == "")
            self::$pdo = Conection::connect();
            
        $stmt = self::$pdo->prepare($query);
        $stmt->execute();
    }

    #Save Dirección
    static private function saveDirSol($solicitud,$cvetipo,$cvesolicitud){

        $sql = "
            INSERT INTO bbva_solicitud_direcciones
              (
                _cvesolicitud,
                _cvetipo,
                paises_id,
                codigo_postal,
                nivel1,
                nivel2,
                colonia,
                calle,
                exterior,
                interior,
                manzana,
                lote,
                supermanzana,
                vialidad_referencia_1,
                vialidad_referencia_2,
                vialidad_referencia_3,
                conjunto,
                condominio,
                entrada,
                edificio,
                nivel,
                departamento,
                nivel3
              )
            VALUES
              (
                '$cvesolicitud',
                '$cvetipo',
                '".$solicitud->paises_id."',
                '".$solicitud->codigo_postal."',
                '".$solicitud->nivel1."',
                '".$solicitud->nivel2."',
                '".$solicitud->colonia."',
                '".$solicitud->calle."',
                '".$solicitud->exterior."',
                '".$solicitud->interior."',
                '".$solicitud->manzana."',
                '".$solicitud->lote."',
                '".$solicitud->supermanzana."',
                '".$solicitud->vialidad_referencia_1."',
                '".$solicitud->vialidad_referencia_2."',
                '".$solicitud->vialidad_referencia_3."',
                '".$solicitud->conjunto."',
                '".$solicitud->condominio."',
                '".$solicitud->entrada."',
                '".$solicitud->edificio."',
                '".$solicitud->nivel."',
                '".$solicitud->departamento."',
                '".$solicitud->nivel3."'
              )
        ";
        //echo $sql;
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
    }

    #Del Direcciones Solicitud
    static private function delDirSol($cvesolicitud){
        $sql = "
            DELETE  FROM bbva_solicitud_direcciones
            WHERE   _cvesolicitud = '$cvesolicitud'
        ";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
    }

    #Existe Folio UT (Solicitud)
    static private function existeFolioUT($folioUT){
        $sql = "
            SELECT  cvesolicitud
            FROM    bbva_solicitudes
            WHERE   folio = '$folioUT'
        ";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->cvesolicitud;
    }

    //
    static private function getcvesolicitud(){
        $sql = "
            SELECT      cvesolicitud    
            FROM        bbva_solicitudes
            order by    cvesolicitud desc
            limit 1
        ";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->cvesolicitud;
    }

    #Borrar los contactos de la solicitud
    static private function delContactos($cvesolicitud){
        $sql = "
            DELETE  FROM bbva_solicitud_contactos
            WHERE   _cvesolicitud = '$cvesolicitud'
        ";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
    }

    #Registro de contactos de la solicitud
    static private function addContacto($solicitud,$cvetipo,$cvesolicitud){
        $sql = "
            INSERT INTO bbva_solicitud_contactos
              (
                _cvesolicitud,
                _cvetipo,
                nombre,
                apellido_paterno,
                apellido_materno,
                email,
                telefono,
                telefono_movil
              )
            VALUES
              (
                '$cvesolicitud',
                '$cvetipo',
                '".$solicitud->nombre."',
                '".$solicitud->apellido_paterno."',
                '".$solicitud->apellido_materno."',
                '".$solicitud->email."',
                '".$solicitud->telefono."',
                '".$solicitud->telefono_movil."'  
              )
        ";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
    }

    #Actualiza la solicitud en los campos de sisval2
    static private function saveSolicitudSisval($folioUT,$solicitud,$cvesolicitud){

        $cond_suceptible_embargo = "";
        $cond_requiere_valor_liquidacion = "";
        $cond_subsecuente = "";
        $cond_tasacion_anterior_vigencia = "";

        if($solicitud->susceptible_embargo != "") {
            $val = ($solicitud->susceptible_embargo == "Si") ? 1:0;
            $cond_suceptible_embargo = "susceptible_embargo = '" . $val . "',";
        }

        if($solicitud->requiere_valor_liquidacion != "") {
            $val = ($solicitud->requiere_valor_liquidacion == "Si") ? 1:0;
            $cond_requiere_valor_liquidacion = "requiere_valor_liquidacion = '" . $val . "',";
        }

        if($solicitud->tasacion_anterior_vigencia != "")
            $cond_tasacion_anterior_vigencia = "tasacion_anterior_vigencia = '".$solicitud->tasacion_anterior_vigencia."',";

        $idVivNueUsa = $solicitud->nuevo_usado_id;
        if($solicitud->nuevo_usado_id == 2)
            $idVivNueUsa = 0;

        //Obtenemos el foliosisval
        $cveavaluo = self::getFoliosisval($cvesolicitud);

        if($cveavaluo == "") {
            #Genera foliosisval
            $cveavaluo = self::generaFoliosisval($folioUT, $cvesolicitud);
        }

        if(!empty($cveavaluo)){
        
            #*** = Dar de alta en la base de datos

            //Determina si el avalúo es SHF o NO SHF (*)
            /*============================================================================
                nota: se hace el ajuste para que el propósito 12 no se considere como shf
                modified: 15/03/2024 13:21 (cambio solicitado vía whatsapp)
              ============================================================================*/
            //$propositosSHF = array(1,2,3,4,5,6,7,8,9,10,11,12,26,30,33);
            //$propositosSHF = array(1,2,3,4,5,6,7,8,9,10,11,26,30,33);
            $propositosSHF = array(1,2,3,4,5,6,7,8,10,11,26,30,33,44);
            if(in_array($solicitud->finalidades_id,$propositosSHF)){

                $cond_shf = true;
                /*============================================================================================================
                    se deshabilita la condición  del propósito shf número 12, ya que al ser el propósito 12 no shf, ya no se
                    entraría a la condición.
                    modified: 15/03/2024 13:21 (cambio solicitado vía whatsapp)
                 =============================================================================================================*/
                /*
                if($solicitud->finalidades_id == 12){
                    if($solicitud->productos_id == 1 || $solicitud->productos_id == 2)
                        $cond_shf = true;
                    else
                        $cond_shf = false;
                }*/
                
                if($cond_shf){

                    //Entonces es SHF
                    $condEsp        = "shf_cve_esp = '1',";
                    $condTipoServ   = "shf_cve_tiposervicio = '0',";    

                }else{

                    //Entonces es un NO SHF
                    $condEsp        = "shf_cve_esp = '0',";
                    $condTipoServ   = "shf_cve_tiposervicio = '1',";

                }

            }else{

                //Entonces es un NO SHF
                $condEsp        = "shf_cve_esp = '0',";
                $condTipoServ   = "shf_cve_tiposervicio = '1',";

            }

            ////////////////////////////////////////

            //Fecha de solicitud
            $fechas = new fechas();
            $hoy = $fechas->getFecha('Y-m-d H:i:s');
            ////////////////////////

            #Update avaluos
            $sqlAva = "
                UPDATE  avaluos
                SET     $condEsp
                        $condTipoServ
                        viv_num_vivienda    = '".$solicitud->numero_vivienda."',
                        vn_longitud         = '".$solicitud->longitud."',
                        vn_latitud          = '".$solicitud->latitud."',
                        vn_altitud          = '".$solicitud->altitud."',
                        cuv                 = '".$solicitud->clave_unica_vivienda."',
                        shf_num_predial     = '".$solicitud->cuenta_predial."',
                        costo_referencia    = '".$solicitud->precio_valor_estimado."',
                        estatus             = '0',
                        fecha               = '$hoy'
                WHERE   foliosisval         = '$cveavaluo'
            ";
            //echo $sqlAva."\n\n";
            $stmtAva = self::$pdo->prepare($sqlAva);
            $stmtAva->execute();

            #Update webservices
            $sqlWS = "
                UPDATE  webservices
                SET     viv_numero_vivienda = '".$solicitud->numero_vivienda."',
                        viv_cp              = '".$solicitud->direcciones->inmueble->codigo_postal."',
                        viv_estado          = '".$solicitud->direcciones->inmueble->nivel1."',
                        viv_mpio            = '".$solicitud->direcciones->inmueble->nivel2."',
                        viv_colonia         = '".$solicitud->direcciones->inmueble->colonia."',
                        viv_calle           = '".$solicitud->direcciones->inmueble->calle."',
                        viv_num_exterior    = '".$solicitud->direcciones->inmueble->exterior."',
                        viv_num_interior    = '".$solicitud->direcciones->inmueble->interior."',
                        viv_manzana         = '".$solicitud->direcciones->inmueble->manzana."',
                        viv_lote            = '".$solicitud->direcciones->inmueble->lote."',
                        viv_supermanzana    = '".$solicitud->direcciones->inmueble->supermanzana."',
                        viv_entre_calle1    = '".$solicitud->direcciones->inmueble->vialidad_referencia_1."',
                        viv_entre_calle2    = '".$solicitud->direcciones->inmueble->vialidad_referencia_2."',
                        viv_entre_calle3    = '".$solicitud->direcciones->inmueble->vialidad_referencia_3."',
                        viv_nombre_frente   = '".$solicitud->direcciones->inmueble->conjunto."',
                        viv_condominio      = '".$solicitud->direcciones->inmueble->condominio."',
                        viv_entrada         = '".$solicitud->direcciones->inmueble->entrada."',
                        viv_edificio        = '".$solicitud->direcciones->inmueble->edificio."',
                        viv_nivel           = '".$solicitud->direcciones->inmueble->nivel."',
                        viv_departamento    = '".$solicitud->direcciones->inmueble->departamento."',
                        viv_localidad_clave = '".$solicitud->direcciones->inmueble->nivel3."',
                        fecha_solicitud     = '$hoy',
                        fecha_alta2         = '$hoy'
                WHERE   foliosisval         = '$cveavaluo'
            ";
            //echo $sqlWS."\n\n";
            $stmtWS = self::$pdo->prepare($sqlWS);
            $stmtWS->execute();


            //$solicitud->contactos[0]->
            //'".$solicitud->nombre."',
            //'".$solicitud->apellido_paterno."',
            //'".$solicitud->apellido_materno."',
            //'".$solicitud->email."',
            //'".$solicitud->telefono."',
            //'".$solicitud->telefono_movil."'

            $nombre_contacto_tmp = $solicitud->contactos[0]->nombre." ".$solicitud->contactos[0]->apellido_paterno." ".$solicitud->contactos[0]->apellido_materno;

            $contacto_tel = $solicitud->contactos[0]->telefono_movil;

            #Update info_sisval
            $sqlInfo = "
                UPDATE  info_sisval
                SET     tipo_persona_solicitante    = '".$solicitud->solicitante_tipos_personas_id."',
                        nombre_solicitante          = '".$solicitud->solicitante_nombre."',
                        paterno_solicitante         = '".$solicitud->solicitante_paterno."',
                        materno_solicitante         = '".$solicitud->solicitante_materno."',
                        solicitante                 = '".$solicitud->solicitante_nombre.' '.$solicitud->solicitante_paterno.' '.$solicitud->solicitante_materno."',
                        solicitante_nombre          = '".$solicitud->solicitante_nombre."',
                        solicitante_app             = '".$solicitud->solicitante_paterno."',
                        solicitante_apm             = '".$solicitud->solicitante_materno."',
                        solicitante_tel             = '".$solicitud->solicitante_telefono."',
                        solicitante_movil           = '".$solicitud->solicitante_movil."',
                        solicitante_email           = '".$solicitud->solicitante_email."',
                        nss_solicitante             = '".$solicitud->solicitante_numero_seguridad_social."',
                        curp_solicitante            = '".$solicitud->solicitante_curp."',
                        propietario                 = '".$solicitud->propietario_nombre."',
                        propietario_nombre          = '".$solicitud->propietario_nombre."',
                        nombre_propietario          = '".$solicitud->propietario_nombre."',
                        propietario_tel             = '".$solicitud->propietario_telefono."',
                        propietario_rfc             = '".$solicitud->propietario_rfc."', 
                        curp_propietario            = '".$solicitud->propietario_curp."',
                        contacto                    = '".$nombre_contacto_tmp."',
                        contacto_tel                = '".$contacto_tel."',
                        id_viv_nueva_usada          = '".$idVivNueUsa."',
                        nombre_solicitante2         = '".$solicitud->acreditado_nombre."',
                        rfc_solicitante2            = '".$solicitud->acreditado_tributaria_clave."',
                        escritura_num_notaria       = '".$solicitud->notario_numero."',
                        escritura_nombre_notario    = '".$solicitud->notario_nombre."',
                        escritura_num               = '".@$solicitud->notario_escritura."',
                        escritura_volumen           = '".$solicitud->notario_volumen."',
                        escritura_libro             = '".$solicitud->notario_libro."',
                        escritura_distrito_judicial_notario = '".$solicitud->notario_plaza."',
                        cp_solicitante              = '".$solicitud->direcciones->solicitante->codigo_postal."',
                        clave_estado_solicitante    = '".$solicitud->direcciones->solicitante->nivel1."',
                        clave_municipio_solicitante = '".$solicitud->direcciones->solicitante->nivel2."',
                        colonia_solicitante         = '".$solicitud->direcciones->solicitante->colonia."',
                        calle_solicitante           = '".$solicitud->direcciones->solicitante->calle."',
                        numext_solicitante          = '".$solicitud->direcciones->solicitante->exterior."',
                        numint_solicitante          = '".$solicitud->direcciones->solicitante->interior."',
                        manzana_solicitante         = '".$solicitud->direcciones->solicitante->manzana."',
                        lote_solicitante            = '".$solicitud->direcciones->solicitante->lote."',
                        supermanzana_solicitante    = '".$solicitud->direcciones->solicitante->supermanzana."',
                        entre_calle1_solicitante    = '".$solicitud->direcciones->solicitante->vialidad_referencia_1."',
                        entre_calle2_solicitante    = '".$solicitud->direcciones->solicitante->vialidad_referencia_2."',
                        entre_calle3_solicitante    = '".$solicitud->direcciones->solicitante->vialidad_referencia_3."',
                        conjunto_solicitante        = '".$solicitud->direcciones->solicitante->conjunto."',
                        condominio_solicitante      = '".$solicitud->direcciones->solicitante->condominio."',
                        entrada_solicitante         = '".$solicitud->direcciones->solicitante->entrada."',
                        edificio_solicitante        = '".$solicitud->direcciones->solicitante->edificio."',
                        nivel_solicitante           = '".$solicitud->direcciones->solicitante->nivel."',
                        departamento_solicitante    = '".$solicitud->direcciones->solicitante->departamento."',
                        clave_localidad_solicitante = '".$solicitud->direcciones->solicitante->nivel3."',
                        cp_propietario              = '".$solicitud->direcciones->propietario->codigo_postal."',
                        clave_estado_propietario    = '".$solicitud->direcciones->propietario->nivel1."',
                        clave_municipio_propietario = '".$solicitud->direcciones->propietario->nivel2."',
                        colonia_propietario         = '".$solicitud->direcciones->propietario->colonia."',
                        calle_propietario           = '".$solicitud->direcciones->propietario->calle."',
                        numext_propietario          = '".$solicitud->direcciones->propietario->exterior."',
                        numint_propietario          = '".$solicitud->direcciones->propietario->interior."',
                        manzana_propietario         = '".$solicitud->direcciones->propietario->manzana."',
                        lote_propietario            = '".$solicitud->direcciones->propietario->lote."',
                        supermanzana_propietario    = '".$solicitud->direcciones->propietario->supermanzana."',
                        entre_calle1_propietario    = '".$solicitud->direcciones->propietario->vialidad_referencia_1."',
                        entre_calle2_propietario    = '".$solicitud->direcciones->propietario->vialidad_referencia_2."',
                        entre_calle3_propietario    = '".$solicitud->direcciones->propietario->vialidad_referencia_3."',
                        conjunto_propietario        = '".$solicitud->direcciones->propietario->conjunto."',
                        condominio_propietario      = '".$solicitud->direcciones->propietario->condominio."',
                        entrada_propietario         = '".$solicitud->direcciones->propietario->entrada."',
                        edificio_propietario        = '".$solicitud->direcciones->propietario->edificio."',
                        nivel_propietario           = '".$solicitud->direcciones->propietario->nivel."',
                        departamento_propietario    = '".$solicitud->direcciones->propietario->departamento."',
                        clave_localidad_propietario = '".$solicitud->direcciones->propietario->nivel3."'
                WHERE   foliosisval                 = '$cveavaluo'
            ";
            //echo $sqlInfo."\n\n";
            $stmtInfo = self::$pdo->prepare($sqlInfo);
            $stmtInfo->execute();

            //hay que obtener el valor de la base de datos
            //$solicitud->crs_id
            $cat_crs = Catalogos::catcrs();
            $cr_garantia = $cat_crs[$solicitud->crs_id]; 

            //especialidades
            $cat_especialidades = Catalogos::getespecialidades();
            $cveespecialidad = $cat_especialidades[$solicitud->categorias_inmueble_id];

            //tipo de bien
            $cat_tipo_bien = Catalogos::get_tipo_bien();
            $tipo_bien_val = $cat_tipo_bien[$solicitud->tipos_inmueble_id];

            //tipo de servicio (productos)
            //$cat_tipo_serv = Catalogos::get_tipo_servicio_conversion();
            //$tipo_servicio = $cat_tipo_serv[$solicitud->productos_id];

            #Update datos bancomer
            $sqlDB = "
                UPDATE  datos_bancomer
                SET     proposito                   = '".$solicitud->finalidades_id."',
                        tipo_servicio               = '".$solicitud->productos_id."',
                        $cond_suceptible_embargo
                        $cond_requiere_valor_liquidacion
                        cr_garantia                 = '".$cr_garantia."',
                        cr_oficina                  = '".$solicitud->crs_oficina."',
                        especialidad                = '".$cveespecialidad."',
                        tipo_bien_valuar            = '".$tipo_bien_val."',
                        nombre_proyecto             = '".$solicitud->nombre_proyecto."',
                        numero_segundo_credito      = '".$solicitud->numero_segundo_credito."',
                        tasacion_anterior_folio     = '".$solicitud->tasacion_anterior_folio."',
                        $cond_tasacion_anterior_vigencia
                        no_credito                  = '".$solicitud->numero_credito."',
                        _cvesolicitud               = '$cvesolicitud'
                WHERE   _cveavaluo                  = '$cveavaluo'
            ";
            //echo $sqlDB."\n\n";
            $stmtDB = self::$pdo->prepare($sqlDB);
            $stmtDB->execute();

            return $cveavaluo;

        }else
            return "";
    }

    #Alta del foliosisval
    static private function generaFoliosisval($folioUT,$cvesolicitud){
        $sql = "
            INSERT INTO avaluos
              (
                folio_cliente,
                shf_cliente,
                shf_cliente_dif,
                estatus
              )
            VALUES
              (
                '$folioUT',
                '1588',
                '1588',
                '0'
              )
        ";
        //echo $sql."<br />";
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        $cveavaluo = self::$pdo->lastInsertId();
        
        self::$cveavaluo = $cveavaluo;
      
        #webservices
        $sqlWS = "
            INSERT INTO webservices
              (
                foliosisval,
                estatus
              )
            VALUES
              (
                '$cveavaluo',
                '0'
              )
        ";
        //echo $sqlWS."<br />";
        $stmtWS = self::$pdo->prepare($sqlWS);
        $stmtWS->execute();

        #info_sisval
        $sqlInfo = "
            INSERT INTO info_sisval
              (
                foliosisval
              )
            VALUES
              (
                '$cveavaluo'
              )
        ";
        //echo $sqlInfo."<br />";
        $stmtInfo = self::$pdo->prepare($sqlInfo);
        $stmtInfo->execute();

        #Alta datos complementarios BBVA
        $sqlDB = "
            INSERT INTO datos_bancomer
              (
                _cveavaluo,
                _cvesolicitud
              )
            VALUES
              (
                '$cveavaluo',
                '$cvesolicitud'
              )
        ";
        //echo $sqlDB."<br />";
        $stmtDB = self::$pdo->prepare($sqlDB);
        $stmtDB->execute();

        return $cveavaluo;
    }

    static private function getFoliosisval($cvesolicitud){
        $sql = "
            SELECT  _cveavaluo
            FROM    datos_bancomer
            WHERE   _cvesolicitud = '$cvesolicitud'
        ";
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->_cveavaluo;
    }

    /*
    #Actualiza la solicitud en los campos de sisval2
    static private function saveSolicitudSisval($folioUT,$solicitud,$cvesolicitud){

        $cond_suceptible_embargo = "";
        $cond_requiere_valor_liquidacion = "";

        if($solicitud->susceptible_embargo != "")
            $cond_suceptible_embargo = "susceptible_embargo = '".$solicitud->susceptible_embargo."',";

        if($solicitud->requiere_valor_liquidacion != "")
            $cond_requiere_valor_liquidacion  = "requiere_valor_liquidacion = '".$solicitud->requiere_valor_liquidacion."',";

        if($solicitud->subsecuente != "")
            $cond_subsecuente = "subsecuente = '".$solicitud->subsecuente."',";

        if($solicitud->tasacion_anterior_vigencia != "")
            $cond_tasacion_anterior_vigencia = "tasacion_anterior_vigencia = '".$solicitud->tasacion_anterior_vigencia."',";

        #Genera foliosisval
        $cveavaluo = self::generaFoliosisval($folioUT,$cvesolicitud);

        #*** = Dar de alta en la base de datos
        #Update avaluos
        $sqlAva = "
            UPDATE  avaluos
            SET     viv_num_vivienda    = '".$solicitud->numero_vivienda."',
                    vn_longitud         = '".$solicitud->longitud."',
                    vn_latitud          = '".$solicitud->latitud."',
                    vn_altitud          = '".$solicitud->altitud."',
                    cuv                 = '".$solicitud->clave_unica_vivienda."',
                    shf_num_predial     = '".$solicitud->cuenta_predial."'
            WHERE   foliosisval         = '$cveavaluo'
        ";
        echo $sqlAva."\n\n";

        #Update webservices
        $sqlWS = "
            UPDATE  webservices
            SET     viv_numero_vivienda = '".$solicitud->numero_vivienda."',
                    viv_cp              = '".$solicitud->direcciones->inmueble->codigo_postal."',
                    viv_estado          = '".$solicitud->direcciones->inmueble->nivel1."',
                    viv_mpio            = '".$solicitud->direcciones->inmueble->nivel2."',
                    viv_colonia         = '".$solicitud->direcciones->inmueble->colonia."',
                    viv_calle           = '".$solicitud->direcciones->inmueble->calle."',
                    viv_num_ext         = '".$solicitud->direcciones->inmueble->exterior."',
                    viv_num_interior    = '".$solicitud->direcciones->inmueble->interior."',
                    viv_manzana         = '".$solicitud->direcciones->inmueble->manzana."',
                    viv_lote            = '".$solicitud->direcciones->inmueble->lote."',
                    viv_supermanzana    = '".$solicitud->direcciones->inmueble->supermanzana."',
                    viv_entre_calle1    = '".$solicitud->direcciones->inmueble->vialidad_referencia_1."',
                    viv_entre_calle2    = '".$solicitud->direcciones->inmueble->vialidad_referencia_2."',
                    viv_entre_calle3    = '".$solicitud->direcciones->inmueble->vialidad_referencia_3."', #***
                    viv_nombre_frente   = '".$solicitud->direcciones->inmueble->conjunto."',
                    viv_condominio      = '".$solicitud->direcciones->inmueble->condominio."',
                    viv_entrada         = '".$solicitud->direcciones->inmueble->entrada."',
                    viv_edificio        = '".$solicitud->direcciones->inmueble->edificio."',
                    viv_nivel           = '".$solicitud->direcciones->inmueble->nivel."',
                    viv_departamento    = '".$solicitud->direcciones->inmueble->departamento."',
                    viv_localidad_clave = '".$solicitud->direcciones->inmueble->nivel3."', #***

            WHERE   foliosisval         = '$cveavaluo'
        ";
        echo $sqlWS."\n\n";
        //


        #Update info_sisval
        $sqlInfo = "
            UPDATE  info_sisval
            SET     tipo_persona_solicitante    = '".$solicitud->solicitante_tipos_personas_id."',
                    nombre_solicitante          = '".$solicitud->solicitante_nombre."',
                    paterno_solicitante         = '".$solicitud->solicitante_paterno."',
                    materno_solicitante         = '".$solicitud->solicitante_materno."',
                    solicitante                 = '".$solicitud->solicitante_nombre.' '.$solicitud->solicitante_paterno.' '.$solicitud->solicitante_materno."',
                    solicitante_nombre          = '".$solicitud->solicitante_nombre."',
                    solicitante_app             = '".$solicitud->solicitante_paterno."',
                    solicitante_apm             = '".$solicitud->solicitante_materno."',
                    solicitante_tel             = '".$solicitud->solicitante_telefono."',
                    solicitante_movil           = '".$solicitud->solicitante_movil."',  #***
                    solicitante_email           = '".$solicitud->solicitante_email."',  #***
                    nss_solicitante             = '".$solicitud->solicitante_numero_seguridad_social."',
                    curp_solicitante            = '".$solicitud->solicitante_curp."',
                    propietario                 = '".$solicitud->propietario_nombre."',
                    propietario_nombre          = '".$solicitud->propietario_nombre."',
                    nombre_propietario          = '".$solicitud->propietario_nombre."',
                    propietario_tel             = '".$solicitud->propietario_telefono."',
                    propietario_rfc             = '".$solicitud->propietario_rfc."', #***
                    curp_propietario            = '".$solicitud->propietario_curp."',
                    id_viv_nueva_usada          = '".$solicitud->nuevo_usado_id."',
                    nombre_solicitante2         = '".$solicitud->acreditado_nombre."',
                    rfc_solicitante2            = '".$solicitud->acreditado_tributaria_clave."', #***

                    escritura_num_notaria       = '".$solicitud->notario_numero."',
                    escritura_nombre_notario    = '".$solicitud->notario_nombre."',
                    escritura_num               = '".$solicitud->notario_escritura."',
                    escritura_volumen           = '".$solicitud->notario_volumen."',
                    escritura_libro             = '".$solicitud->notario_libro."', #***
                    escritura_distrito_judicial_notario = '".$solicitud->notario_plaza."',

                    cp_solicitante              = '".$solicitud->direcciones->solicitante->codigo_postal."',
                    clave_estado_solicitante    = '".$solicitud->direcciones->solicitante->nivel1."' #***
                    clave_municipio_solicitante = '".$solicitud->direcciones->solicitante->nivel2."',
                    colonia_solicitante         = '".$solicitud->direcciones->solicitante->colonia."',
                    calle_solicitante           = '".$solicitud->direcciones->solicitante->calle."',
                    numext_solicitante          = '".$solicitud->direcciones->solicitante->exterior."',
                    numint_solicitante          = '".$solicitud->direcciones->solicitante->interior."',
                    manzana_solicitante         = '".$solicitud->direcciones->solicitante->manzana."', #***
                    lote_solicitante            = '".$solicitud->direcciones->solicitante->lote."', #***
                    supermanzana_solicitante    = '".$solicitud->direcciones->solicitante->supermanzana."', #***
                    entre_calle1_solicitante    = '".$solicitud->direcciones->solicitante->vialidad_referencia_1."', #***
                    entre_calle2_solicitante    = '".$solicitud->direcciones->solicitante->vialidad_referencia_2."', #***
                    entre_calle3_solicitante    = '".$solicitud->direcciones->solicitante->vialidad_referencia_3."', #***
                    conjunto_solicitante        = '".$solicitud->direcciones->solicitante->conjunto."', #***
                    condominio_solicitante      = '".$solicitud->direcciones->solicitante->condominio."', #***
                    entrada_solicitante         = '".$solicitud->direcciones->solicitante->entrada."', #***
                    edificio_solicitante        = '".$solicitud->direcciones->solicitante->edificio."', #***
                    nivel_solicitante           = '".$solicitud->direcciones->solicitante->nivel."', #***
                    departamento_solicitante    = '".$solicitud->direcciones->solicitante->departamento."', #***
                    clave_localidad_solicitante = '".$solicitud->direcciones->solicitante->nivel3."', #***
                    cp_propietario              = '".$solicitud->direcciones->propietario->codigo_postal."',
                    clave_estado_propietario    = '".$solicitud->direcciones->propietario->nivel1."' #***
                    clave_municipio_propietario = '".$solicitud->direcciones->propietario->nivel2."',
                    colonia_propietario         = '".$solicitud->direcciones->propietario->colonia."',
                    calle_propietario           = '".$solicitud->direcciones->propietario->calle."',
                    numext_propietario          = '".$solicitud->direcciones->propietario->exterior."',
                    numint_propietario          = '".$solicitud->direcciones->propietario->interior."',
                    manzana_propietario         = '".$solicitud->direcciones->propietario->manzana."', #***
                    lote_propietario            = '".$solicitud->direcciones->propietario->lote."', #***
                    supermanzana_propietario    = '".$solicitud->direcciones->propietario->supermanzana."', #***
                    entre_calle1_propietario    = '".$solicitud->direcciones->propietario->vialidad_referencia_1."', #***
                    entre_calle2_propietario    = '".$solicitud->direcciones->propietario->vialidad_referencia_2."', #***
                    entre_calle3_propietario    = '".$solicitud->direcciones->propietario->vialidad_referencia_3."', #***
                    conjunto_propietario        = '".$solicitud->direcciones->propietario->conjunto."', #***
                    condominio_propietario      = '".$solicitud->direcciones->propietario->condominio."', #***
                    entrada_propietario         = '".$solicitud->direcciones->propietario->entrada."', #***
                    edificio_propietario        = '".$solicitud->direcciones->propietario->edificio."', #***
                    nivel_propietario           = '".$solicitud->direcciones->propietario->nivel."', #***
                    departamento_propietario    = '".$solicitud->direcciones->propietario->departamento."', #***
                    clave_localidad_propietario = '".$solicitud->direcciones->propietario->nivel3."', #***

            WHERE   foliosisval                 = '$cveavaluo'
        ";
        echo $sqlInfo."\n\n";

        #Update datos bancomer
        $sqlDB = "
            UPDATE  datos_bancomer
            SET     proposito                   = '".$solicitud->finalidades_id."',
                    tipo_servicio               = '".$solicitud->productos_id."',
                    $cond_suceptible_embargo            #***
                    $cond_requiere_valor_liquidacion    #***
                    crs_garantia                = '".$solicitud->crs_id."',
                    crs_oficina                 = '".$solicitud->crs_oficina."', #***
                    especialidad                = '".$solicitud->categorias_inmueble_id."',
                    tipo_bien_valuar            = '".$solicitud->tipos_inmueble_id."',
                    nombre_proyecto             = '".$solicitud->nombre_proyecto."',  #***
                    $cond_subsecuente           #***
                    numero_credito              = '".$solicitud->numero_credito."', #***
                    numero_segundo_credito      = '".$solicitud->numero_segundo_credito."',  #***
                    tasacion_anterior_folio     = '".$solicitud->tasacion_anterior_folio."', #***
                    $cond_tasacion_anterior_vigencia  #***

            WHERE   foliosisval         = '$cveavaluo'
        ";
        echo $sqlDB."\n\n";

    }*/


    static public function getNomEdo($edo){
        
        $sql = "
            SELECT      cveedo,
              			nom_edo,
               			abrev_edo
             FROM       estados
             WHERE      cveedo = '$edo'
        ";
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->nom_edo;
    }

    static public function getNomMpio($edo,$mpio){
        
        $sql = "
            SELECT      cvempio,
                		cveedo,
                		nom_mpio
            FROM        municipios
            WHERE       cveedo  = '$edo'
            AND         cvempio = '$mpio'
        ";
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->nom_mpio;
    }
}
