<?php
/**
 * Created by PhpStorm.
 * User: server
 * Date: 2/07/23
 * Time: 01:18 AM
 */

require_once "conection.php";
require_once "catalogos.php";
class rechazarIncidenciaSetModel{

    static public $pdo;

    /***********************
     * Estatus Incidencias:
     * 0 = Dado de alta en valor
     * 1 = Reportado a BBVA
     * 2 = Incidencia aceptada por BBVA
     * 3 = Incidencia rechazada por BBVA
     ************************/
    static public function saveRechazoIncidencia($folioUV,$detalle,$hoy){

        //New Get Folio UT
        $folioUT = self::getFolioUT($folioUV);

        //New Get Folio Sisval
        rechazarIncidenciaSetController::$cveavaluo = self::getFoliosisval($folioUV);

        //Get solicitud
        $cvesolicitud = self::getCveSolicitud($folioUT);
        if(empty($cvesolicitud))
            return array(false,1);

        $cveavaluo = rechazarIncidenciaSetController::$cveavaluo = self::getFoliosisvalBySolicitud($cvesolicitud);

        //total de incidencias
        $total_incidencias = self::getTotalIncidencias($cveavaluo);

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        if($total_incidencias == 1)
            $cond = "fecha_suspencion = NULL";

        if($total_incidencias == 2)
            $cond = "fecha_suspencion2 = NULL";
        

        if($total_incidencias <= 2){

            $queryinfo = "
                UPDATE  info_sisval
                SET     $cond
                WHERE   foliosisval = '$cveavaluo'
            ";
            //echo $queryinfo;
        
            $stmt2 = self::$pdo->prepare($queryinfo);
            $stmt2->execute();
        }


        if($total_incidencias > 2){
            
            //obtenemos la ùltima incidencia
            $queryInciAll = "
                SELECT    cvefecha_suspension_aval
                FROM      fechas_suspensiones_aval
                WHERE     _cveavaluo = '$cveavaluo'
                ORDER BY  cvefecha_suspension_aval DESC
            ";
            $stmtInciAll = self::$pdo->prepare($queryInciAll);
            $stmtInciAll->execute();
            $cvefecha_suspension_aval = @$stmtInciAll->fetchAll(PDO::FETCH_CLASS)[0]->cvefecha_suspension_aval;

            if($cvefecha_suspension_aval != ""){
            
                $query_act_all = "
                    DELETE  FROM  fechas_suspensiones_aval
                    WHERE   cvefecha_suspension_aval = '$cvefecha_suspension_aval'
                 ";
                 //echo $query_act_all."<br />";
                 $stmtInci_act = self::$pdo->prepare($query_act_all);
                 $stmtInci_act->execute();
            }
        }

        //Obtenemos el id de la incidencia
        #New
        $cvesolicitud_incidencia = self::getUltimaIncidencia($cvesolicitud);

        $sql = "
            UPDATE  bbva_solicitud_incidencias
            SET     solicitud_incidencia_detalle_banco = '$detalle',
                    solicitud_incidencia_fecha_banco = '$hoy',
                    solicitud_incidencia_status = '3'
            WHERE   cvesolicitud_incidencia = '$cvesolicitud_incidencia'
        ";
        
        //AND     solicitud_incidencia_status IN ('1','3')
        
        //echo $sql."<br />";
        
        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();

        //Quitamos el tipo de incidencia en datos bancomer
        //Modified: 05/09/2023 21:15
        $queryDB = "
            UPDATE  datos_bancomer
            SET     tipo_incidencia = NULL
            WHERE   _cveavaluo = '$cveavaluo'
        ";
        $stmtInciDB = self::$pdo->prepare($queryDB);
        $stmtInciDB->execute();

        if($stmt->rowCount()>0)
            return array(true);
        return array(false,2);
    }

    #Existe Folio UT (Solicitud)
    static private function getCveSolicitud($folioUT){
        $sql = "
            SELECT  cvesolicitud
            FROM    bbva_solicitudes
            WHERE   folio = '$folioUT'
        ";
        //echo $sql;

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->cvesolicitud;
    }

    #Existe Folio sisval
    static public function getFoliosisvalBySolicitud($cvesolicitud){
        $sql = "
            SELECT  _cveavaluo
            FROM    datos_bancomer
            WHERE   _cvesolicitud = '$cvesolicitud'
        ";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->_cveavaluo;
    }

    #New
    static public function getFolioUT($cveavaluo){
        $sql = "
            SELECT  folio
            FROM    bbva_solicitudes
            WHERE   _cveavaluo2 = '$cveavaluo'
        ";
        //echo $sql;
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->folio;
    }

    #New
    static public function getFoliosisval($folioUV){
        $sql = "
            SELECT  _cveavaluo
            FROM    bbva_solicitudes
            WHERE   _cveavaluo2 = '$folioUV'
        ";
        //echo $sql;
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->_cveavaluo;
    }

    /*===============================================================
     * Para determinar la última incidencia generada de la solicitud
     *===============================================================*/
    #New
    static public function getUltimaIncidencia($cvesolicitud){
        try{

            if(self::$pdo == "")
                self::$pdo = Conection::connect();

            $sql = "
                SELECT    cvesolicitud_incidencia
                FROM      bbva_solicitud_incidencias
                WHERE     _cvesolicitud = '$cvesolicitud'
                ORDER BY  cvesolicitud_incidencia DESC
                LIMIT     0,1
            ";
            $stmt = self::$pdo->prepare($sql);
            $stmt->execute();
            return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->cvesolicitud_incidencia;
        }catch (PDOException $e){
            return false;
        }
    }

    static private function getTotalIncidencias($cveavaluo){

        if(self::$pdo == "")
            self::$pdo = Conection::connect();
    
        //Total de incidencias mediante las fechas de suspensión
        $queryTotalInci = "
            SELECT  fecha_suspencion,
                    fecha_suspencion2
            FROM    info_sisval
            WHERE   foliosisval = '$cveavaluo'    
        ";
        //echo $queryTotalInci."<br />";
        $stmt = self::$pdo->prepare($queryTotalInci);
        $stmt->execute();
        $resInci = $stmt->fetchAll(PDO::FETCH_CLASS);
        foreach ($resInci as $i => $incidencia){
            //var_dump($incidencia);
            if($incidencia->fecha_suspencion != "" && $incidencia->fecha_suspencion != "0000-00-00 00:00:00")
                $totalInci = 1;

           if($incidencia->fecha_suspencion2 != "" && $incidencia->fecha_suspencion2 != "0000-00-00 00:00:00")
              $totalInci = 2;
        }

        $queryTotalInci2 = "
            SELECT    count(*) as total
            FROM      fechas_suspensiones_aval
            WHERE     _cveavaluo = '$cveavaluo'    
        ";
        //echo $queryTotalInci2."<br />";
        $stmt2 = self::$pdo->prepare($queryTotalInci2);
        $stmt2->execute();
        $totalInci2 = $stmt2->fetchAll(PDO::FETCH_CLASS)[0]->total;
        //echo "El total de inci 2 es:".$totalInci2."<br />";
        $totalInci = $totalInci+$totalInci2;
        //echo "El total de incidencias son:".$totalInci."<br />";
        //////////////////////////////////////////////////

        return $totalInci;
    }
}
