<?php
/**
 * Created by PhpStorm.
 * User: server
 * Date: 1/07/23
 * Time: 11:20 PM
 */

require_once "conection.php";
class getModel{

    static public $pdo;

    /*===========================
     * Get Datos de la solicitud
     *===========================*/

    static public function getDatosSolicitud($cveavaluo){

        try{
            $sql = "
            SELECT      avaluos.foliosisval,
                        webservices.fecha_alta2 as fecha_asignacion,
                        bbva_solicitudes.folio,
                        bbva_solicitudes.entidades_id,
                        bbva_solicitudes.finalidades_id,
                        bbva_solicitudes.productos_id,
                        bbva_solicitudes.precio_valor_estimado,
                        bbva_solicitudes.susceptible_embargo,
                        bbva_solicitudes.requiere_valor_liquidacion,
                        bbva_solicitudes.crs_id,
                        bbva_solicitudes.crs_oficina,
                        bbva_solicitudes.categorias_inmueble_id,
                        bbva_solicitudes.tipos_inmueble_id,
                        bbva_solicitudes.nombre_proyecto,
                        bbva_solicitudes.numero_vivienda,
                        bbva_solicitudes.subsecuente,
                        bbva_solicitudes.numero_credito,
                        bbva_solicitudes.numero_segundo_credito,
                        bbva_solicitudes.solicitante_tipos_personas_id,
                        bbva_solicitudes.solicitante_nombre,
                        bbva_solicitudes.solicitante_paterno,
                        bbva_solicitudes.solicitante_materno,
                        CONCAT(bbva_solicitudes.solicitante_nombre,' ',bbva_solicitudes.solicitante_paterno,' ',bbva_solicitudes.solicitante_materno) as solicitante_nombre_completo,
                        bbva_solicitudes.solicitante_tributaria_clave,
                        bbva_solicitudes.solicitante_telefono,
                        bbva_solicitudes.solicitante_movil,
                        bbva_solicitudes.solicitante_email,
                        bbva_solicitudes.solicitante_numero_seguridad_social,
                        bbva_solicitudes.solicitante_curp,
                        bbva_solicitudes.acreditado_nombre,
                        bbva_solicitudes.acreditado_tributaria_clave,
                        bbva_solicitudes.tasacion_anterior_folio,
                        bbva_solicitudes.tasacion_anterior_vigencia,
                        bbva_solicitudes.propietario_nombre,
                        bbva_solicitudes.propietario_telefono,
                        bbva_solicitudes.propietario_rfc,
                        bbva_solicitudes.propietario_curp,
                        bbva_solicitudes.promotor_comercial,
                        bbva_solicitudes.promotor_clave_cuenta,
                        bbva_solicitudes.latitud,
                        bbva_solicitudes.longitud,
                        bbva_solicitudes.altitud,
                        bbva_solicitudes.nuevo_usado_id,
                        bbva_solicitudes.clave_unica_vivienda,
                        bbva_solicitudes.cuenta_predial,
                        bbva_solicitudes.notario_numero,
                        bbva_solicitudes.notario_nombre,
                        bbva_solicitudes.notario_plaza,
                        bbva_solicitudes.notario_escritura,
                        bbva_solicitudes.notario_libro,
                        bbva_solicitudes.notario_volumen,
                        bbva_solicitudes.comentarios,
                        bbva_solicitudes.urgente,
                        (SELECT  CONCAT (nombre, ' ', ap_paterno, ' ', ap_materno) as controlador FROM conval WHERE conval.cvevalor = avaluos.con_cvesisval) as controlador,
                        #(SELECT  CONCAT (nombre, ' ', ap_paterno, ' ', ap_materno) as valuador FROM conval WHERE conval.cvevalor = avaluos.val_cvesisval) as valuador,
                        (SELECT  CONCAT (nombre, ' ', ap_paterno, ' ', ap_materno) as valuador FROM conval WHERE conval.cveshf = avaluos.per_clave LIMIT 0,1) as valuador,
                        info_sisval.fecha_aceptacion_asignacion_bbva
            FROM        bbva_solicitudes
            INNER JOIN  datos_bancomer
            ON          datos_bancomer._cvesolicitud = bbva_solicitudes.cvesolicitud
            INNER JOIN  avaluos
            ON          avaluos.foliosisval = datos_bancomer._cveavaluo
            INNER JOIN  webservices
            ON          webservices.foliosisval = avaluos.foliosisval
            INNER JOIN  info_sisval
            ON          info_sisval.foliosisval = webservices.foliosisval
            WHERE       avaluos.foliosisval = '$cveavaluo'
            ORDER BY    bbva_solicitudes.cvesolicitud DESC
        ";
            //echo $sql;
            if (self::$pdo == "")
                self::$pdo = Conection::connect();

            $stmt = self::$pdo->prepare($sql);
            $stmt->execute();
            return @$stmt->fetchAll(PDO::FETCH_CLASS)[0];
        }catch(PDOException $e){
            die("Error:" . $e->getMessage());
        }
    }

    static public function getAsignacionDirecciones($folioUV,$cvetipo){

        //Get cvesolicitud
        $cvesolicitud = self::existeFolioUV($folioUV);

        //get direcciones
        $sql = "
            SELECT    cvesolicitud_direccion,
                      _cvesolicitud,
                      _cvetipo,
                      paises_id,
                      codigo_postal,
                      nivel1,
                      nivel2,
                      colonia,
                      calle,
                      exterior,
                      interior,
                      manzana,
                      lote,
                      supermanzana,
                      vialidad_referencia_1,
                      vialidad_referencia_2,
                      vialidad_referencia_3,
                      conjunto,
                      condominio,
                      entrada,
                      edificio,
                      nivel,
                      departamento,
                      nivel3
            FROM      bbva_solicitud_direcciones
            WHERE     _cvesolicitud = '$cvesolicitud'
            AND       _cvetipo = '$cvetipo'
        ";
        //echo $sql;
        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0];

    }

    #Existe folio UV
    static private function existeFolioUV($folioUV){
        $sql = "
            SELECT  cvesolicitud
            FROM    bbva_solicitudes
            WHERE   _cveavaluo = '$folioUV'
        ";
        //echo $sql."<br />";

        if(self::$pdo == "")
            self::$pdo = Conection::connect();

        $stmt = self::$pdo->prepare($sql);
        $stmt->execute();
        return @$stmt->fetchAll(PDO::FETCH_CLASS)[0]->cvesolicitud;
    }
}

