<?php

namespace Sabre\DAV\Xml;

use PHPUnit_Framework_TestCase;
use Sabre\Xml\Reader;
use Sabre\Xml\Writer;

abstract class XmlTest extends PHPUnit_Framework_TestCase {

    protected $elementMap = [];
    protected $namespaceMap = ['DAV:' => 'd'];
    protected $contextUri = '/';

    function write($input) {

        $writer = new Writer();
        $writer->contextUri = $this->contextUri;
        $writer->namespaceMap = $this->namespaceMap;
        $writer->openMemory();
        $writer->setIndent(true);
        $writer->write($input);
        return $writer->outputMemory();

    }

    function assertParsedValue($expected, $xml, array $elementMap = []) {

        $result = $this->parse($xml, $elementMap);
        $this->assertEquals($expected, $result['value']);

    }

    function parse($xml, array $elementMap = []) {

        $reader = new Reader();
        $reader->elementMap = array_merge($this->elementMap, $elementMap);
        $reader->xml($xml);
        return $reader->parse();

    }

    function cleanUp() {

        libxml_clear_errors();

    }

}
